﻿using System;
using System.Globalization;
using System.Windows.Data;
using System.Windows.Media;

namespace WpfApp1.Tools
{
    public class StringToBrushConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string color = value as string;
            if (!string.IsNullOrEmpty(color))
            {
                try
                {
                    // 将颜色字符串转换为 Brush
                    Brush originalBrush = (Brush)new BrushConverter().ConvertFromString(color);

                    // 调整透明度，使颜色变得浅一些
                    SolidColorBrush solidColorBrush = originalBrush as SolidColorBrush;
                    if (solidColorBrush != null)
                    {
                        // 将不透明度降低，调整为 50%（0.5）
                        Color colorWithTransparency = solidColorBrush.Color;
                        colorWithTransparency.A = 128; // 调整Alpha通道（取值范围0-255）
                        return new SolidColorBrush(colorWithTransparency);
                    }

                    return originalBrush; // 返回原始颜色
                }
                catch
                {
                    // 如果颜色格式不正确，返回默认颜色
                    return Brushes.Black;
                }
            }

            return Brushes.Black; // 默认颜色
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
